@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-4 sm:mb-6">Admin Dashboard</h1>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 mb-6 sm:mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-full">
                    <i class="fas fa-user-md text-blue-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Doctors</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['doctors'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-green-100 rounded-full">
                    <i class="fas fa-check-circle text-green-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Verified Doctors</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['verified_doctors'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-yellow-100 rounded-full">
                    <i class="fas fa-clock text-yellow-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Pending Doctors</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['pending_doctors'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-purple-100 rounded-full">
                    <i class="fas fa-building text-purple-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Branches</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['branches'] }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 mb-6 sm:mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-indigo-100 rounded-full">
                    <i class="fas fa-prescription text-indigo-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Prescriptions</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['prescriptions'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-teal-100 rounded-full">
                    <i class="fas fa-calendar text-teal-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['appointments'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-orange-100 rounded-full">
                    <i class="fas fa-hourglass-half text-orange-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Pending Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['pending_appointments'] }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-pink-100 rounded-full">
                    <i class="fas fa-users text-pink-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Patients</p>
                    <p class="text-xl sm:text-2xl font-bold">{{ $stats['patients'] }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Notifications Section -->
    @if(isset($notifications) && $notifications->count() > 0)
    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-3 sm:mb-4 gap-2">
            <h2 class="text-lg sm:text-xl font-bold">Recent Notifications</h2>
            <div class="flex gap-2">
                <a href="{{ route('admin.notifications') }}" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">View All</a>
                <form method="POST" action="{{ route('admin.notifications.mark-all-read') }}" class="inline">
                    @csrf
                    <button type="submit" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">Mark all as read</button>
                </form>
            </div>
        </div>
        <div class="space-y-3">
            @foreach($notifications as $notification)
            <div class="border-l-4 {{ isset($notification->data['type']) && $notification->data['type'] === 'doctor_registration' ? 'border-blue-500 bg-blue-50' : 'border-green-500 bg-green-50' }} p-4 rounded">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-start gap-2">
                            @if(isset($notification->data['type']) && $notification->data['type'] === 'doctor_registration')
                                <i class="fas fa-user-md text-blue-600 mt-1"></i>
                            @else
                                <i class="fas fa-prescription text-green-600 mt-1"></i>
                            @endif
                            <div class="flex-1">
                                <p class="font-semibold text-gray-800 text-sm sm:text-base">{{ $notification->data['message'] ?? 'New notification' }}</p>
                                @if(isset($notification->data['type']) && $notification->data['type'] === 'doctor_registration')
                                    <div class="mt-2 text-xs sm:text-sm text-gray-600">
                                        <p><strong>Doctor:</strong> {{ $notification->data['doctor_name'] ?? 'N/A' }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <a href="{{ route('admin.doctors') }}" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">Review Doctor</a>
                                    </div>
                                @elseif(isset($notification->data['type']) && $notification->data['type'] === 'prescription_created')
                                    <div class="mt-2 text-xs sm:text-sm text-gray-600">
                                        <p><strong>Prescription #:</strong> {{ $notification->data['prescription_number'] ?? 'N/A' }}</p>
                                    </div>
                                    <div class="mt-2">
                                        <a href="{{ route('prescriptions.show', $notification->data['prescription_id']) }}" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">View Prescription</a>
                                    </div>
                                @endif
                                <p class="text-xs text-gray-500 mt-2">{{ $notification->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    </div>
                    <form method="POST" action="{{ route('admin.notifications.mark-read', $notification->id) }}" class="ml-4">
                        @csrf
                        <button type="submit" class="text-gray-400 hover:text-gray-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </form>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">Quick Actions</h2>
            <div class="space-y-2">
                <a href="{{ route('admin.doctors') }}" class="block w-full bg-blue-600 hover:bg-blue-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    Manage Doctors
                </a>
                <a href="{{ route('admin.branches') }}" class="block w-full bg-green-600 hover:bg-green-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    Manage Branches
                </a>
                <a href="{{ route('admin.users') }}" class="block w-full bg-purple-600 hover:bg-purple-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    Manage Users
                </a>
                <a href="{{ route('admin.settings') }}" class="block w-full bg-indigo-600 hover:bg-indigo-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    System Settings
                </a>
                <a href="{{ route('admin.reports.index') }}" class="block w-full bg-cyan-600 hover:bg-cyan-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    <i class="fas fa-chart-bar mr-2"></i>Reports & Analytics
                </a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-4 sm:p-6">
            <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">View All Records</h2>
            <div class="space-y-2">
                <a href="{{ route('admin.prescriptions') }}" class="block w-full bg-indigo-600 hover:bg-indigo-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    View All Prescriptions
                </a>
                <a href="{{ route('admin.appointments') }}" class="block w-full bg-teal-600 hover:bg-teal-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    View All Appointments
                </a>
                <a href="{{ route('admin.patients') }}" class="block w-full bg-pink-600 hover:bg-pink-700 text-white text-center py-2 px-4 rounded text-sm sm:text-base">
                    View All Patients
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

